/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1093;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;
import org.joml.Matrix4f;
import slimeknights.mantle.Mantle;

public class SimpleBlockModel
implements IUnbakedGeometry<SimpleBlockModel> {
    public static final Loader LOADER = new Loader();
    static final class_2960 BAKE_LOCATION = Mantle.getResource("dynamic_model_baking");
    @Nullable
    private class_2960 parentLocation;
    private final List<class_785> parts;
    private final Map<String, Either<class_4730, String>> textures;
    private class_793 parent;

    public SimpleBlockModel(@Nullable class_2960 parentLocation, Map<String, Either<class_4730, String>> textures, List<class_785> parts) {
        this.parts = parts;
        this.textures = textures;
        this.parentLocation = parentLocation;
    }

    public List<class_785> getElements() {
        return this.parts.isEmpty() && this.parent != null ? this.parent.method_3433() : this.parts;
    }

    public void fetchParent(class_793 owner, Function<class_2960, class_1100> modelGetter) {
        if (this.parent != null || this.parentLocation == null) {
            return;
        }
        LinkedHashSet chain = Sets.newLinkedHashSet();
        this.parent = SimpleBlockModel.getParent(modelGetter, chain, this.parentLocation, owner.field_4252);
        if (this.parent == null) {
            this.parent = SimpleBlockModel.getMissing(modelGetter);
            this.parentLocation = class_1088.field_5374;
        }
        class_793 link = this.parent;
        while (link.field_4247 != null && link.field_4253 == null) {
            chain.add(link);
            link.field_4253 = SimpleBlockModel.getParent(modelGetter, chain, link.field_4247, link.field_4252);
            if (link.field_4253 == null) {
                link.field_4253 = SimpleBlockModel.getMissing(modelGetter);
                link.field_4247 = class_1088.field_5374;
            }
            link = link.field_4253;
        }
    }

    @Nullable
    private static class_793 getParent(Function<class_2960, class_1100> modelGetter, Set<class_1100> chain, class_2960 location, String name) {
        class_1100 unbaked = modelGetter.apply(location);
        if (unbaked == null) {
            Mantle.logger.warn("No parent '{}' while loading model '{}'", (Object)location, (Object)name);
            return null;
        }
        if (chain.contains(unbaked)) {
            Mantle.logger.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)name, (Object)chain.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)location);
            return null;
        }
        if (!(unbaked instanceof class_793)) {
            throw new IllegalStateException("BlockModel parent has to be a block model.");
        }
        return (class_793)unbaked;
    }

    @Nonnull
    private static class_793 getMissing(Function<class_2960, class_1100> modelGetter) {
        class_1100 model = modelGetter.apply((class_2960)class_1088.field_5374);
        if (!(model instanceof class_793)) {
            throw new IllegalStateException("Failed to load missing model");
        }
        return (class_793)model;
    }

    public static Collection<class_4730> getTextures(class_793 owner, List<class_785> elements, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet((Object[])new class_4730[]{owner.method_24077("particle")});
        for (class_785 part : elements) {
            for (class_783 face : part.field_4230.values()) {
                class_4730 material = owner.method_24077(face.field_4224);
                if (Objects.equals(material.method_24147(), class_1047.method_4539())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_4224, (Object)owner.field_4252));
                }
                textures.add(material);
            }
        }
        return textures;
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 owner) {
        this.fetchParent(owner, modelGetter);
    }

    public static void bakePart(class_1093.class_1094 builder, class_793 owner, class_785 part, class_3665 transform, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        for (class_2350 direction : part.field_4230.keySet()) {
            class_783 face = (class_783)part.field_4230.get(direction);
            String texture = face.field_4224;
            if (texture.charAt(0) == '#') {
                texture = texture.substring(1);
            }
            class_1058 sprite = spriteGetter.apply(owner.method_24077(texture));
            class_777 bakedQuad = class_793.method_3447((class_785)part, (class_783)face, (class_1058)sprite, (class_2350)direction, (class_3665)transform, (class_2960)location);
            if (face.field_4225 == null) {
                builder.method_4748(bakedQuad);
                continue;
            }
            builder.method_4745(class_2350.method_23225((Matrix4f)transform.method_3509().method_22936(), (class_2350)face.field_4225), bakedQuad);
        }
    }

    public static class_1087 bakeModel(class_793 owner, List<class_785> elements, class_3665 transform, class_806 overrides, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        class_1058 particle = spriteGetter.apply(owner.method_24077("particle"));
        class_1093.class_1094 builder = new class_1093.class_1094(owner.method_3444(), owner.method_24298().method_24299(), true, owner.method_3443(), overrides).method_4747(particle);
        for (class_785 part : elements) {
            SimpleBlockModel.bakePart(builder, owner, part, transform, spriteGetter, location);
        }
        return builder.method_4746();
    }

    public static class_1087 bakeDynamic(class_793 owner, List<class_785> elements, class_3665 transform) {
        return SimpleBlockModel.bakeModel(owner, elements, transform, class_806.field_4292, class_4730::method_24148, BAKE_LOCATION);
    }

    public class_1087 bakeModel(class_793 owner, class_3665 transform, class_806 overrides, Function<class_4730, class_1058> spriteGetter, class_2960 location) {
        return SimpleBlockModel.bakeModel(owner, this.getElements(), transform, overrides, spriteGetter, location);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 location, boolean isGui3d) {
        return this.bakeModel(owner, transform, overrides, spriteGetter, location);
    }

    public class_1087 bakeDynamic(class_793 owner, class_3665 transform) {
        return SimpleBlockModel.bakeDynamic(owner, this.getElements(), transform);
    }

    public static SimpleBlockModel deserialize(JsonDeserializationContext context, JsonObject json) {
        ImmutableMap textureMap;
        class_2960 parent;
        String parentName = class_3518.method_15253((JsonObject)json, (String)"parent", (String)"");
        class_2960 class_29602 = parent = parentName.isEmpty() ? null : new class_2960(parentName);
        if (json.has("textures")) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            class_2960 atlas = class_1723.field_21668;
            JsonObject textures = class_3518.method_15296((JsonObject)json, (String)"textures");
            for (Map.Entry entry : textures.entrySet()) {
                builder.put((Object)((String)entry.getKey()), (Object)class_793.class_795.method_24079((class_2960)atlas, (String)((JsonElement)entry.getValue()).getAsString()));
            }
            textureMap = builder.build();
        } else {
            textureMap = Collections.emptyMap();
        }
        List<Object> parts = json.has("elements") ? SimpleBlockModel.getModelElements(context, (JsonElement)class_3518.method_15261((JsonObject)json, (String)"elements"), "elements") : Collections.emptyList();
        return new SimpleBlockModel(parent, (Map<String, Either<class_4730, String>>)textureMap, (List<class_785>)parts);
    }

    public static List<class_785> getModelElements(JsonDeserializationContext context, JsonElement array, String name) {
        if (array.isJsonObject()) {
            return ImmutableList.of((Object)((class_785)context.deserialize((JsonElement)array.getAsJsonObject(), class_785.class)));
        }
        if (array.isJsonArray()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement json : array.getAsJsonArray()) {
                builder.add((Object)((class_785)context.deserialize(json, class_785.class)));
            }
            return builder.build();
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a JsonArray or JsonObject");
    }

    @Nullable
    public class_2960 getParentLocation() {
        return this.parentLocation;
    }

    public Map<String, Either<class_4730, String>> getTextures() {
        return this.textures;
    }

    public class_793 getParent() {
        return this.parent;
    }

    private static class Loader
    implements IGeometryLoader<SimpleBlockModel> {
        private Loader() {
        }

        public SimpleBlockModel read(JsonObject json, JsonDeserializationContext context) {
            return SimpleBlockModel.deserialize(context, json);
        }
    }
}

